/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;

public class WorldUtils {
    public static String getDimensionId(Level world) {
        ResourceLocation id = world.dimension().location();
        return id != null ? id.getNamespace() + "_" + id.getPath() : "__fallback";
    }

    @Nullable
    public static Level getBestWorld(Minecraft mc) {
        IntegratedServer server = mc.getSingleplayerServer();
        if (mc.level != null && server != null) {
            return server.getLevel(mc.level.dimension());
        }
        return mc.level;
    }

    @Nullable
    public static LevelChunk getBestChunk(int chunkX, int chunkZ, Minecraft mc) {
        ServerLevel world;
        IntegratedServer server = mc.getSingleplayerServer();
        LevelChunk chunk = null;
        if (mc.level != null && server != null && (world = server.getLevel(mc.level.dimension())) != null) {
            chunk = world.getChunk(chunkX, chunkZ);
        }
        if (chunk != null) {
            return chunk;
        }
        return mc.level != null ? mc.level.getChunk(chunkX, chunkZ) : null;
    }

    public static int getHighestSectionYOffset(ChunkAccess chunk) {
        int yMax = chunk.getHighestFilledSectionIndex();
        yMax = yMax == -1 ? chunk.getMinY() : SectionPos.sectionToBlockCoord((int)chunk.getSectionYFromSectionIndex(yMax));
        return yMax;
    }

    public static Holder<DimensionType> getDimensionTypeEntry(DimensionType key, @Nonnull RegistryAccess registry) {
        try {
            return registry.lookupOrThrow(Registries.DIMENSION_TYPE).wrapAsHolder((Object)key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<DimensionType> getDimensionTypeEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(Registries.DIMENSION_TYPE).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<DimensionType> getDimensionTypeEntry(String id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(Registries.DIMENSION_TYPE).get(ResourceLocation.tryParse((String)id)).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<Biome> getBiomeEntry(ResourceKey<Biome> key, @Nonnull RegistryAccess registry) {
        try {
            return registry.lookupOrThrow(Registries.BIOME).getOrThrow(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<Biome> getBiomeEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(Registries.BIOME).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<Biome> getBiomeEntry(String id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(Registries.BIOME).get(ResourceLocation.tryParse((String)id)).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Holder<Biome> getPlains(@Nonnull RegistryAccess registry) {
        return WorldUtils.getBiomeEntry((ResourceKey<Biome>)Biomes.PLAINS, registry);
    }

    public static Holder<Biome> getWastes(@Nonnull RegistryAccess registry) {
        return WorldUtils.getBiomeEntry((ResourceKey<Biome>)Biomes.NETHER_WASTES, registry);
    }

    public static Holder<Biome> getTheEnd(@Nonnull RegistryAccess registry) {
        return WorldUtils.getBiomeEntry((ResourceKey<Biome>)Biomes.THE_END, registry);
    }
}

